; JAWS Script for ChattyInfty
; Copyright 2007, Infty Project
; Written by Koichi Inoue

include "HjConst.jsh"

Globals
	string globalInftySourceBarString,
	int globalIsSourceBarVisible
Const
	CID_LaTeXSourceBar 99,
	WC_INFTY_MATHEDITOR "InftyMathEditorControl",
	STR_LINE_END " /]"

Function updateBrailleBuffer()
	var Handle hSourceWindow,
	int subtype, int state, string value,
	string prefix
	let prefix = ""
	let hSourceWindow = FindWindowWithClassAndId(GetAppMainWindow(GetCurrentWindow()), "Edit", CID_LaTeXSourceBar)
	if (hSourceWindow == 0) then
		let globalInftySourceBarString = ""
		let globalIsSourceBarVisible = false
		return
	endif
	GetObjectInfoByName(hSourceWindow, "LaTeX Source", 1, subtype, state, value)
	;if (BrailleGetCellCount() < StringLength(value)) then
	;	let prefix = "__"
	;	else
	;	let prefix = "_"
	;endif
	let globalInftySourceBarString = prefix + value + STR_LINE_END
	let globalIsSourceBarVisible = true
	return true
EndFunction

Function BrailleBuildLine()
var
	Handle hCurrentWindow
	if (!BrailleInUse()) then
		return
	endif
	if (!IsPCCursor()) then
		return
	endif
	let hCurrentWindow = GetCurrentWindow()
	if (GetWindowClass(hCurrentWindow) != WC_INFTY_MATHEDITOR) then
		return
	endif
	updateBrailleBuffer()
	BrailleMessage(globalInftySourceBarString, 0, 0)

EndFunction
